package net.sf.aguacate.definition.compiler.impl;

import java.util.List;
import java.util.Map;

import net.sf.aguacate.definition.Definition;
import net.sf.aguacate.definition.compiler.DefinitionCompiler;

/**
 * <pre>
 * {
 *   "name": "...",
 *   "datasource": "...",
 *   "fields": {
 *   },
 *   "validations": [
 *   ],
 *   "sentences": [
 *   ]
 * }
 * </pre>
 */
public class DefinitionCompilerDefault implements DefinitionCompiler {

	private final ParserField parserField;

	private final ParserValidator parserValidator;

	private final ParserProcessor parserProcessor;

	public DefinitionCompilerDefault() {
		this.parserField = new ParserField();
		this.parserValidator = new ParserValidator();
		this.parserProcessor = new ParserProcessor();
	}

	@SuppressWarnings("unchecked")
	@Override
	public Definition compile(Map<String, Object> source) {
		String datasource = (String) source.get("datasource");
		Map<String, Object> fields = (Map<String, Object>) source.get("fields");
		List<Map<String, Object>> validators = (List<Map<String, Object>>) source.get("validators");
		List<Map<String, Object>> processors = (List<Map<String, Object>>) source.get("processors");
		return new Definition(datasource, parserField.parse(fields), parserValidator.parse(validators),
				parserProcessor.parse(processors));
	}

}
