package net.sf.aguacate.context.spi.sql.impl;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;

import net.sf.aguacate.function.Function;
import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.function.FunctionEvalResult;

public abstract class AbstractSentenceSql implements Function {

	public static final String SQL_INSERT = "SQL_INSERT";

	public static final String SQL_INSERT_RECOVER_ID = "SQL_INSERT_RECOVER_ID";

	public static final String SQL_UPDATE = "SQL_UPDATE";

	public static final String SQL_DELETE = "SQL_DELETE";

	public static final String SQL_SELECT_SINGLE_ROW = "SQL_SELECT_SINGLE_ROW";

	public static final String SQL_SELECT_LIST = "SQL_SELECT_LIST";

	public static final String SQL_SELECT_MULTIPLE_ROW = "SQL_SELECT_MULTIPLE_ROW";

	public static final String INSERT = "INSERT";

	public static final String INSERT_RECOVER_ID = "INSERT_RECOVER_ID";

	public static final String UPDATE = "UPDATE";

	public static final String SELECT_SINGLE_ROW = "SELECT_SINGLE_ROW";

	public static final String SELECT_SINGLE = "SELECT_SINGLE";

	public static final String SELECT_MULTIPLE_ROW = "SELECT_MULTIPLE_ROW";

	public static final String SELECT = "SELECT";

	public static final String BEGIN_TRANSACTION = "BEGIN_TRANSACTION";

	public static final String END_TRANSACTION = "END_TRANSACTION";

	public static final String DELETE = "DELETE";

	public static final String JSON_RESPONSE = "JSON_RESPONSE";

	public static final String CONTEXT = "CONTEXT";

	private final String name;

	private final String message;

	private final Collection<String> methods;

	public AbstractSentenceSql(String name, String message, Collection<String> methods) {
		this.name = name;
		this.message = message;
		this.methods = methods;
	}

	@Override
	public FunctionEvalResult evaluate(FunctionContext functionContext, Map<String, Object> context) {
		try {
			return evaluate0(functionContext, context);
		} catch (SQLException e) {
			throw new IllegalStateException(e);
		}
	}

	protected abstract FunctionEvalResult evaluate0(FunctionContext functionContext, Map<String, Object> context)
			throws SQLException;

	@Override
	public String getName() {
		return name;
	}

	public String getMessage() {
		return message;
	}

	@Override
	public boolean validFor(String method) {
		return methods.contains(method);
	}

}
