package net.sf.aguacate.context.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import net.sf.aguacate.context.ContextValidationResult;
import net.sf.aguacate.context.ContextValidator;
import net.sf.aguacate.function.Function;
import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.function.FunctionEvalResult;

public class ContextValidatorSql implements ContextValidator {

	private static final Logger LOGGER = LogManager.getLogger(ContextValidatorSql.class);

	private final Function[] functions;

	public ContextValidatorSql(Collection<Function> functions) {
		this.functions = functions.toArray(new Function[functions.size()]);
	}

	@Override
	public ContextValidationResult validate(FunctionContext functionContext, String method,
			Map<String, Object> context) {
		for (Function function : functions) {
			String name = function.getName();
			if (function.validFor(method)) {
				LOGGER.trace("execution {}", name);
				FunctionEvalResult result = function.evaluate(functionContext, context);
				boolean success = result.isSuccess();
				LOGGER.debug("execution {}: {}", name, success);
				if (success) {
					String outputName = function.getOutputName();
					LOGGER.trace(outputName);
					if (outputName != null) {
						String[] outputContext = function.getOutputContext();
						if (outputContext != null && outputContext.length > 0) {
							Map<String, Object> ctx = context;
							for (String ctxName : outputContext) {
								@SuppressWarnings("unchecked")
								Map<String, Object> temp = (Map<String, Object>) ctx.get(ctxName);
								// TODO: check if temp is null
								ctx = temp;
							}
							LOGGER.trace("working ctx: {}", ctx);
							ctx.put(outputName, result.getData());
						} else {
							context.put(outputName, result.getData());
						}
					}
					LOGGER.trace("new context: {}", context);
				} else {
					return new ContextValidationResult(Collections.singletonList(result), null);
				}
			} else {
				LOGGER.info("avoid execution: {}", name);
			}
		}
		return new ContextValidationResult(null, context);
	}

}
