package net.sf.aguacate.configuration;

import java.util.Map;

import net.sf.aguacate.context.ContextProcessor;
import net.sf.aguacate.context.ContextValidator;
import net.sf.aguacate.field.format.FieldFormat;
import net.sf.aguacate.validator.InputValidator;

public interface Configuration {

	String getDatasource();

	InputValidator getValidatorConverter(String method);

	boolean accepts(String method);

	Map<String, FieldFormat> getOutputFields(String method);

	ContextValidator getContextValidator();

	ContextProcessor getContextProcessor();

	String[] methods();

}
