/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.util.filesystem;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.sf.aguacate.util.filesystem.EventHandler;
import net.sf.aguacate.util.filesystem.spi.WatchdogRunner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FileSystemObserver {
    private static final Logger LOGGER = LogManager.getLogger(FileSystemObserver.class);
    private static Collection<WatchdogRunner> runners = Collections.emptyList();
    private static ThreadGroup group = new ThreadGroup("observer");

    private FileSystemObserver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void watch(Path directory, EventHandler handler) {
        WatchdogRunner runner = new WatchdogRunner(directory, handler);
        Class<FileSystemObserver> clazz = FileSystemObserver.class;
        synchronized (FileSystemObserver.class) {
            LOGGER.info("{} handled by {}", (Object)directory, (Object)handler);
            ArrayList<WatchdogRunner> temp = new ArrayList<WatchdogRunner>(runners);
            temp.add(runner);
            int size = temp.size();
            StringBuilder builder = new StringBuilder(group.getName());
            builder.append('-');
            if (size < 100) {
                builder.append('0');
                if (size < 10) {
                    builder.append('0');
                }
            }
            builder.append(size);
            builder.append('-');
            builder.append(directory.getFileName());
            String name = builder.toString();
            LOGGER.trace("{}: {}", (Object)name, temp);
            runners = temp;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            new Thread(group, runner, name).start();
            return;
        }
    }
}

