/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.util.dynamic.bridge;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import net.sf.aguacate.util.dynamic.bridge.DynamicFactory;
import net.sf.aguacate.util.dynamic.bridge.spi.DynamicFactoryScript;

public final class DynamicFactoryCoupling {
    private static final ScriptEngineManager MANAGER = new ScriptEngineManager();
    private static Map<String, DynamicFactoryScript> mimetypes = Collections.emptyMap();
    private static Map<String, DynamicFactoryScript> extensions = Collections.emptyMap();

    private DynamicFactoryCoupling() {
    }

    public static DynamicFactory getByExtension(String extension) {
        return DynamicFactoryCoupling.getBy(true, extension);
    }

    public static DynamicFactory getByMimetype(String mimetype) {
        return DynamicFactoryCoupling.getBy(false, mimetype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DynamicFactory getBy(boolean extension, String key) {
        Map<String, DynamicFactoryScript> map = extension ? extensions : mimetypes;
        DynamicFactoryScript factory = map.get(key);
        if (factory == null) {
            ScriptEngineManager scriptEngineManager = MANAGER;
            synchronized (scriptEngineManager) {
                factory = map.get(key);
                if (factory == null) {
                    if (extension) {
                        List<String> list;
                        for (DynamicFactoryScript current : extensions.values()) {
                            list = current.getEngine().getFactory().getMimeTypes();
                            if (!list.contains(key)) continue;
                            factory = current;
                            break;
                        }
                        if (factory == null) {
                            for (DynamicFactoryScript current : mimetypes.values()) {
                                list = current.getEngine().getFactory().getExtensions();
                                if (!list.contains(key)) continue;
                                factory = current;
                                break;
                            }
                        }
                    } else {
                        List<String> list;
                        for (DynamicFactoryScript current : mimetypes.values()) {
                            list = current.getEngine().getFactory().getExtensions();
                            if (!list.contains(key)) continue;
                            factory = current;
                            break;
                        }
                        if (factory == null) {
                            for (DynamicFactoryScript current : extensions.values()) {
                                list = current.getEngine().getFactory().getMimeTypes();
                                if (!list.contains(key)) continue;
                                factory = current;
                                break;
                            }
                        }
                    }
                    if (factory == null) {
                        ScriptEngine engine = extension ? MANAGER.getEngineByExtension(key) : MANAGER.getEngineByMimeType(key);
                        if (engine == null) {
                            throw new IllegalArgumentException("No engine for: ".concat(key));
                        }
                        factory = new DynamicFactoryScript(engine);
                    }
                    HashMap<String, DynamicFactoryScript> dup = new HashMap<String, DynamicFactoryScript>(map);
                    dup.put(key, factory);
                    if (extension) {
                        extensions = dup;
                    } else {
                        mimetypes = dup;
                    }
                }
            }
        }
        return factory;
    }
}

