/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.util.config.database.spi;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import net.sf.aguacate.util.config.database.spi.AbstractDatabaseInterface;
import net.sf.aguacate.util.parameter.Parameter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractDatabaseInterfaceWithId
extends AbstractDatabaseInterface {
    private static final Logger LOGGER = LogManager.getLogger(AbstractDatabaseInterfaceWithId.class);

    @Override
    public BigInteger executeSqlInsertWithId(Connection connection, String sql, Map<String, Object> context, Parameter[] required, Parameter[] optional, String[] keys) throws SQLException {
        PreparedStatement statement = this.prepareStatement(connection, sql, keys);
        try {
            int position = 1;
            for (Parameter parameter : required) {
                if (!context.containsKey(parameter.getName())) continue;
                statement.setObject(position, parameter.calculateContext(context).get(parameter.getName()));
                ++position;
            }
            for (Parameter parameter : optional) {
                if (!context.containsKey(parameter.getName())) continue;
                statement.setObject(position, parameter.calculateContext(context).get(parameter.getName()));
                ++position;
            }
            LOGGER.debug("execution: {}", (Object)sql);
            int count = statement.executeUpdate();
            if (count == 1) {
                ResultSet generatedKeys = statement.getGeneratedKeys();
                if (generatedKeys.next()) {
                    String key = generatedKeys.getString(1);
                    LOGGER.debug("result({}): {}", (Object)key, (Object)sql);
                    BigInteger bigInteger = new BigInteger(key);
                    return bigInteger;
                }
                LOGGER.warn("No primary key");
                throw new IllegalStateException("No primary key");
            }
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Multiple rows: {}", (Object)count);
            }
            throw new IllegalStateException("Multiple rows");
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException e) {
                LOGGER.error("On close statement", (Throwable)e);
            }
        }
    }

    @Override
    public BigInteger executeInsertWithId(Connection connection, String table, Map<String, Object> context, Parameter[] required, Parameter[] optional, String[] keys) throws SQLException {
        String sql = this.buildInsertWithIdSql(connection.getMetaData().getIdentifierQuoteString(), table, context, required, optional);
        LOGGER.debug("prepare: {}", (Object)sql);
        return this.executeSqlInsertWithId(connection, sql, context, required, optional, keys);
    }

    @Override
    public String buildInsertWithIdSql(String quote, String table, Map<String, Object> context, Parameter[] required, Parameter[] optional) {
        return this.buildInsertSql0(quote, table, context, required, optional).toString();
    }

    abstract PreparedStatement prepareStatement(Connection var1, String var2, String[] var3) throws SQLException;
}

