/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.function.spi.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.function.FunctionEvalResult;
import net.sf.aguacate.function.spi.AbstractFunctionN;
import net.sf.aguacate.script.DynamicCacheCoupling;
import net.sf.aguacate.util.parameter.Parameter;
import net.sf.aguacate.util.type.Str;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FunctionScript
extends AbstractFunctionN {
    private static final Logger LOGGER = LogManager.getLogger(FunctionScript.class);
    private final String[] outputContext;
    private final String outputName;
    private String scriptName;
    private String functionName;

    public FunctionScript(Collection<String> methods, String name, String message, List<Parameter> parameters, List<String> outputContext, String outputName, String scriptName, String functionName) {
        super(methods, name, message, parameters);
        this.scriptName = scriptName;
        this.outputContext = Str.toArray(outputContext);
        this.outputName = outputName;
        this.functionName = functionName;
    }

    @Override
    public FunctionEvalResult evaluate(FunctionContext functionContext, Object[] values, String msg) {
        Object value = DynamicCacheCoupling.get(this.scriptName).exec(this.functionName, values);
        if (value instanceof Map) {
            Map map = (Map)value;
            String message = (String)map.get("message");
            Object val = map.get("value");
            if (message == null) {
                if (val == null) {
                    this.logFailure(msg);
                    return new FunctionEvalResult("Missing state", null);
                }
                this.logSuccess(msg);
                return new FunctionEvalResult(null, val);
            }
            if (val == null) {
                this.logFailure(msg);
                return new FunctionEvalResult(message, null);
            }
            this.logFailure(msg);
            LOGGER.warn("Invalid state: message = {} & value = {}", (Object)message, val);
            return new FunctionEvalResult("Invalid state", null);
        }
        this.logFailure(msg);
        LOGGER.warn("Invalid state: {}", value);
        return new FunctionEvalResult("Invalid state", null);
    }

    @Override
    public String getOutputName() {
        return this.outputName;
    }

    @Override
    public String[] getOutputContext() {
        return this.outputContext;
    }
}

