/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.function.spi.impl;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.aguacate.connector.ConnectorCoupling;
import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.function.FunctionEvalResult;
import net.sf.aguacate.function.spi.AbstractFunction;
import net.sf.aguacate.util.parameter.Parameter;
import net.sf.aguacate.util.parameter.Prm;
import net.sf.aguacate.util.type.Str;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FunctionConnectorCall
extends AbstractFunction {
    private static final Logger LOGGER = LogManager.getLogger(FunctionConnectorCall.class);
    private final String connectorName;
    private final Parameter[] parameters;
    private final String[] outputContext;
    private final String outputName;

    public FunctionConnectorCall(Collection<String> methods, String name, String connectorName, Collection<Parameter> parameters, List<String> outputContext, String outputName) {
        super(methods, name);
        this.connectorName = connectorName;
        this.parameters = Prm.toArray(parameters);
        this.outputContext = Str.toArray(outputContext);
        this.outputName = outputName;
    }

    @Override
    public FunctionEvalResult evaluate(FunctionContext functionContext, Map<String, Object> context) {
        LinkedHashMap<String, Object> prms = new LinkedHashMap<String, Object>();
        for (Parameter parameter : this.parameters) {
            String name = parameter.getName();
            LOGGER.trace(name);
            Map<String, Object> ctx = parameter.calculateContext(context);
            if (!ctx.containsKey(name)) continue;
            prms.put(parameter.getAliasOf(), ctx.get(name));
        }
        return new FunctionEvalResult(true, ConnectorCoupling.execute(this.connectorName, prms));
    }

    @Override
    public String getOutputName() {
        return this.outputName;
    }

    @Override
    public String[] getOutputContext() {
        return this.outputContext;
    }
}

