/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.field;

import java.util.Calendar;
import java.util.Date;
import net.sf.aguacate.validator.ValidationConversionResult;

final class FieldTimeUtil {
    private FieldTimeUtil() {
    }

    static int timeZone(String string) {
        int length = string.length();
        int pos = length - 1;
        if (string.charAt(pos) == 'Z') {
            return pos;
        }
        pos = length - 6;
        char c = string.charAt(pos);
        if ('-' == c || '+' == c) {
            return pos;
        }
        throw new IllegalArgumentException(string);
    }

    static ValidationConversionResult validate(Date min, Date date, Date max) {
        if (date.compareTo(min) < 0) {
            return new ValidationConversionResult("Invalid minimum value");
        }
        if (date.compareTo(max) > 0) {
            return new ValidationConversionResult("Invalid maximum value");
        }
        return new ValidationConversionResult(date);
    }

    static int tzToMinutes(String string) {
        int length = string.length();
        if (string.charAt(length - 1) == 'Z') {
            return 0;
        }
        int hours = Integer.parseInt(string.substring(length - 5, length - 3));
        int mins = Integer.parseInt(string.substring(length - 2));
        char c = string.charAt(length - 6);
        if ('-' == c) {
            return -(hours * 60 + mins);
        }
        if ('+' == c) {
            return hours * 60 + mins;
        }
        throw new IllegalArgumentException(string);
    }

    static int diff(int source, int target) {
        return target - source;
    }

    static int calculateDiff(Calendar now, String ref) {
        int src = FieldTimeUtil.tzToMinutes(ref);
        int tgt = now.getTimeZone().getRawOffset() / 60000;
        return FieldTimeUtil.diff(tgt, src);
    }

    static int calculateDiff(String ref, Calendar now) {
        int src = FieldTimeUtil.tzToMinutes(ref);
        int tgt = now.getTimeZone().getRawOffset() / 60000;
        return FieldTimeUtil.diff(src, tgt);
    }
}

