/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.field;

import java.math.BigInteger;
import net.sf.aguacate.field.FieldNumber;
import net.sf.aguacate.validator.ValidationConversionResult;

public class FieldInteger
extends FieldNumber {
    private final BigInteger minValue;
    private final BigInteger maxValue;

    public FieldInteger(String name, boolean optional, String minValue, String maxValue) {
        super(name, "INTEGER", optional);
        this.minValue = new BigInteger(minValue);
        this.maxValue = new BigInteger(maxValue);
    }

    public BigInteger getMinValue() {
        return this.minValue;
    }

    public BigInteger getMaxValue() {
        return this.maxValue;
    }

    @Override
    public ValidationConversionResult validateAndConvert(Object value) {
        Class<?> klass = value.getClass();
        if (Integer.class == klass || Long.class == klass) {
            return this.validate(this.minValue, BigInteger.valueOf(((Number)value).longValue()), this.maxValue);
        }
        if (String.class == klass) {
            try {
                return this.validate(this.minValue, new BigInteger((String)value), this.maxValue);
            }
            catch (NumberFormatException e) {
                return new ValidationConversionResult("Invalid format");
            }
        }
        return new ValidationConversionResult("Invalid value");
    }
}

