/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.effort;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import net.sf.aguacate.definition.Definition;
import net.sf.aguacate.definition.ExecutionListener;
import net.sf.aguacate.effort.EffortManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class EffortManagerCoupling {
    private static final Logger LOGGER = LogManager.getLogger(EffortManagerCoupling.class);
    private static final EffortManager MANAGER;

    private EffortManagerCoupling() {
    }

    public static void execute(Definition definition, ExecutionListener listener) {
        EffortManagerCoupling.execute(definition, Collections.emptyMap(), listener);
    }

    public static void execute(Definition definition, Map<String, Object> context, ExecutionListener listener) {
        MANAGER.execute(definition, context, listener);
    }

    static {
        Iterator<EffortManager> iterator = ServiceLoader.load(EffortManager.class).iterator();
        if (iterator.hasNext()) {
            MANAGER = iterator.next();
            if (iterator.hasNext()) {
                LOGGER.warn("Unused intance: {}", (Object)iterator.next().getClass().getName());
            }
        } else {
            throw new IllegalStateException("No instance for " + EffortManager.class.getName());
        }
    }
}

