/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.definition.parser.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.aguacate.definition.Definition;
import net.sf.aguacate.definition.compiler.DefinitionCompilerCoupling;
import net.sf.aguacate.definition.parser.DefinitionParser;
import net.sf.aguacate.util.codec.bridge.CodecCoupling;
import net.sf.aguacate.util.filesystem.EventHandler;
import net.sf.aguacate.util.filesystem.FileSystemObserver;
import net.sf.aguacate.util.resource.ResourceLocator;
import net.sf.aguacate.util.resource.impl.ResourceLocatorClassImpl;
import net.sf.aguacate.util.resource.impl.ResourceLocatorFileImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefinitionParserDefault
implements DefinitionParser,
EventHandler {
    private static final Logger LOGGER = LogManager.getLogger(DefinitionParserDefault.class);
    private static final Logger LOGGER2 = LogManager.getLogger((String)"aguacate.file.definition");
    private static final String ENVIRONMENT = "DIRECTORY_DEFINITION";
    private static final File DIRECTORY;
    private static final Map<String, Object> SPECS;
    private static final String SUFFIX = ".json";
    private static final int SUFFIX_LENGTH = 5;
    private final ResourceLocator locator;
    private Map<String, Definition> cache = Collections.emptyMap();

    public DefinitionParserDefault() {
        assert (this.cache != null && this.cache.isEmpty());
        if (DIRECTORY == null) {
            this.locator = new ResourceLocatorClassImpl(Definition.class);
        } else {
            this.locator = new ResourceLocatorFileImpl(DIRECTORY);
            FileSystemObserver.watch(DIRECTORY.toPath(), this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Definition load(String name) {
        Definition definition = this.cache.get(name);
        if (definition == null) {
            DefinitionParserDefault definitionParserDefault = this;
            synchronized (definitionParserDefault) {
                definition = this.cache.get(name);
                if (definition == null) {
                    HashMap<String, Definition> temp = new HashMap<String, Definition>(this.cache);
                    definition = this.load0(name.concat(SUFFIX));
                    temp.put(name, definition);
                    this.cache = temp;
                }
            }
        }
        return definition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Definition load0(String filename) {
        Definition definition;
        LOGGER.debug(filename);
        LOGGER2.info("Loading script: {}", (Object)filename);
        InputStream inputStream = this.locator.open(filename);
        if (inputStream == null) {
            return null;
        }
        try {
            definition = DefinitionCompilerCoupling.compile(this.checkSpecs(CodecCoupling.jsonCodecBridge().decodeMap(new InputStreamReader(inputStream, StandardCharsets.UTF_8))));
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.warn("on close inputstream", (Throwable)e);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        try {
            inputStream.close();
        }
        catch (IOException e) {
            LOGGER.warn("on close inputstream", (Throwable)e);
        }
        return definition;
    }

    Map<String, Object> checkSpecs(Map<String, Object> data) {
        Map specs = (Map)data.get("specs");
        if (specs == null) {
            throw new IllegalArgumentException("no specs");
        }
        if (SPECS.equals(specs)) {
            return data;
        }
        throw new IllegalArgumentException("unsupported specs: ".concat(CodecCoupling.jsonCodecBridge().encode(specs)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDelete(Path directory, Path deleted) {
        String file = deleted.toString();
        if (file.endsWith(SUFFIX)) {
            LOGGER2.warn("Removing script definition: {}", (Object)deleted);
            String name = this.removeSufix(file);
            DefinitionParserDefault definitionParserDefault = this;
            synchronized (definitionParserDefault) {
                if (this.cache.containsKey(name)) {
                    HashMap<String, Definition> temp = new HashMap<String, Definition>(this.cache);
                    temp.remove(name);
                    this.cache = temp;
                }
            }
        } else {
            LOGGER.debug("ignore deleted file: {}", (Object)deleted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUpdate(Path directory, Path updated) {
        String file = updated.toString();
        if (file.endsWith(SUFFIX)) {
            LOGGER2.info("Change detected on definition: {}", (Object)updated);
            String name = this.removeSufix(file);
            DefinitionParserDefault definitionParserDefault = this;
            synchronized (definitionParserDefault) {
                if (this.cache.containsKey(name)) {
                    HashMap<String, Definition> temp = new HashMap<String, Definition>(this.cache);
                    temp.put(name, this.load0(file));
                    this.cache = temp;
                }
            }
        } else {
            LOGGER2.warn("Ignored : {}", (Object)updated);
            LOGGER.debug("ignore updated file: {}", (Object)updated);
        }
    }

    String removeSufix(String name) {
        return name.substring(0, name.length() - 5);
    }

    static {
        assert (5 == SUFFIX.length());
        String temp = System.getProperty(ENVIRONMENT);
        if (temp == null || temp.isEmpty()) {
            temp = System.getenv(ENVIRONMENT);
            if (temp == null || temp.isEmpty()) {
                LOGGER.info("No DIRECTORY_DEFINITION defined, using default");
                DIRECTORY = null;
            } else {
                LOGGER.info("using DIRECTORY_DEFINITION (env): {}", (Object)temp);
                DIRECTORY = new File(temp);
            }
        } else {
            LOGGER.info("using DIRECTORY_DEFINITION (prop): {}", (Object)temp);
            DIRECTORY = new File(temp);
        }
        HashMap<String, Object> spec = new HashMap<String, Object>();
        spec.put("kind", "definition");
        spec.put("format", "1.0");
        SPECS = spec;
    }
}

