/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.definition.compiler.impl;

import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.aguacate.field.Field;
import net.sf.aguacate.field.FieldArray;
import net.sf.aguacate.field.FieldBoolean;
import net.sf.aguacate.field.FieldDate;
import net.sf.aguacate.field.FieldDynamicDate;
import net.sf.aguacate.field.FieldFloat;
import net.sf.aguacate.field.FieldInteger;
import net.sf.aguacate.field.FieldString;
import net.sf.aguacate.field.FieldStructure;
import net.sf.aguacate.field.FieldStructureArray;
import net.sf.aguacate.field.FieldTimeWithZone;
import net.sf.aguacate.util.type.Bool;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ParserField {
    private static final Logger LOGGER = LogManager.getLogger(ParserField.class);
    private static final FastDateFormat FMT_TIME = FastDateFormat.getInstance((String)"HH:mmZZ");
    private static final FastDateFormat FMT_DATE;
    private static final FastDateFormat FMT_DYN_DATE;
    private static final FastDateFormat FMT_DATETIME;

    List<Field> parse(Map<String, Object> source) {
        ArrayList<Field> fields = new ArrayList<Field>(source.size());
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String name = entry.getKey();
            Map meta2 = (Map)entry.getValue();
            fields.add(this.toField(name, meta2));
        }
        return fields;
    }

    Field toField(String name, Map<String, Object> source) {
        String string = (String)source.get("type");
        boolean optional = Bool.valueOf(source.get("optional"));
        switch (string) {
            case "TIME": {
                return new FieldTimeWithZone(name, "TIME", optional, (Format)FMT_TIME, (String)source.get("minval"), (String)source.get("maxval"));
            }
            case "DYNAMIC_DATE": {
                return new FieldDynamicDate(name, optional, (Format)FMT_DYN_DATE, (String)source.get("minval"), (String)source.get("maxval"));
            }
            case "DATE": {
                return new FieldDate(name, optional, (Format)FMT_DATE, (String)source.get("minval"), (String)source.get("maxval"));
            }
            case "DATETIME": {
                return new FieldTimeWithZone(name, "DATETIME", optional, (Format)FMT_DATETIME, (String)source.get("minval"), (String)source.get("maxval"));
            }
            case "FLOAT": {
                return new FieldFloat(name, optional, (String)source.get("minval"), (String)source.get("maxval"));
            }
            case "INTEGER": {
                return new FieldInteger(name, optional, (String)source.get("minval"), (String)source.get("maxval"));
            }
            case "STRING": {
                int minLenth = Integer.parseInt((String)source.get("minlen"));
                int maxLength = Integer.parseInt((String)source.get("maxlen"));
                String regex = (String)source.get("regex");
                LOGGER.trace("{} regex: {}", (Object)name, (Object)regex);
                return new FieldString(name, optional, minLenth, maxLength, regex);
            }
            case "BOOLEAN": {
                return new FieldBoolean(name, optional);
            }
            case "STRUCTURE_ARRAY": {
                Map sub = (Map)source.get("data");
                return new FieldStructureArray(name, optional, this.parse(sub));
            }
            case "STRUCTURE": {
                Map sub = (Map)source.get("data");
                return new FieldStructure(name, optional, this.parse(sub));
            }
            case "ARRAY": {
                Map sub = (Map)source.get("data");
                return new FieldArray(name, optional, (String)sub.get("name"), this.toField("inner", sub), Bool.valueOf(source.get("unique")));
            }
        }
        throw new IllegalArgumentException(string);
    }

    static {
        String date = "yyyy-MM-dd";
        FMT_DATE = FastDateFormat.getInstance((String)"yyyy-MM-dd");
        String dynamic = "yyyy-MM-ddZZ";
        FMT_DYN_DATE = FastDateFormat.getInstance((String)"yyyy-MM-ddZZ");
        String datetime = "yyyy-MM-dd'T'HH:mm:ss.SSSZZ";
        FMT_DATETIME = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
    }
}

