/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.context.impl;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import net.sf.aguacate.context.ContextProcessor;
import net.sf.aguacate.field.format.FieldFormat;
import net.sf.aguacate.function.Function;
import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.function.FunctionEvalResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContextProcessorSql
implements ContextProcessor {
    private static final Logger LOGGER = LogManager.getLogger(ContextProcessorSql.class);
    private final Function[] sentences;

    public ContextProcessorSql(Collection<Function> sentences) {
        this.sentences = sentences.toArray(new Function[sentences.size()]);
    }

    @Override
    public Object process(FunctionContext functionContext, String method, Map<String, Object> context, Map<String, FieldFormat> outputFields) {
        try {
            return this.process(method, context, functionContext);
        }
        catch (RuntimeException | SQLException e) {
            LOGGER.warn("Rollback on exception");
            functionContext.rollback();
            throw new IllegalStateException(e);
        }
    }

    Object process(String method, Map<String, Object> context, FunctionContext functionContext) throws SQLException {
        FunctionEvalResult last = null;
        for (Function sentence : this.sentences) {
            String name = sentence.getName();
            if (sentence.validFor(method)) {
                LOGGER.trace("trying to execute {} with: {}", (Object)name, context);
                FunctionEvalResult sentenceResult = sentence.evaluate(functionContext, context);
                if (sentenceResult.isSuccess()) {
                    LOGGER.debug("succesful execution of {}", (Object)name);
                    String outputName = sentence.getOutputName();
                    if (outputName != null) {
                        String[] outputContext = sentence.getOutputContext();
                        if (outputContext != null && outputContext.length > 0) {
                            Map ctx = context;
                            for (String ctxName : outputContext) {
                                Map temp;
                                ctx = temp = (Map)ctx.get(ctxName);
                            }
                            LOGGER.trace("working ctx: {}", ctx);
                            ctx.put((String)outputName, (Object)sentenceResult.getData());
                        } else {
                            context.put((String)outputName, (Object)sentenceResult.getData());
                        }
                    }
                    LOGGER.trace("context after {}: {}", (Object)name, context);
                    last = sentenceResult;
                    continue;
                }
                LOGGER.warn("unsuccesful execution of {}. Rollback transaction", (Object)name);
                functionContext.rollback();
                return null;
            }
            LOGGER.trace("avoid execution: {}", (Object)name);
        }
        if (last == null) {
            return null;
        }
        return last.getData();
    }
}

