/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.connector.spi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.aguacate.connector.Connector;
import net.sf.aguacate.connector.ConnectorBridge;
import net.sf.aguacate.connector.spi.ConnectorBuilder;
import net.sf.aguacate.connector.spi.ConnectorBuilderImpl;
import net.sf.aguacate.util.codec.bridge.CodecCoupling;
import net.sf.aguacate.util.filesystem.EventHandler;
import net.sf.aguacate.util.filesystem.FileSystemObserver;
import net.sf.aguacate.util.resource.ResourceLocator;
import net.sf.aguacate.util.resource.impl.ResourceLocatorClassImpl;
import net.sf.aguacate.util.resource.impl.ResourceLocatorFileImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConnectorBridgeSpi
implements ConnectorBridge,
EventHandler {
    private static final Logger LOGGER = LogManager.getLogger(ConnectorBridgeSpi.class);
    private static final Logger LOGGER2 = LogManager.getLogger((String)"aguacate.file.connector");
    private static final String SUFFIX = ".json";
    private static final int SUFFIX_LENGTH = 5;
    private static final String ENVIRONMENT = "DIRECTORY_CONNECTOR";
    private static final File DIRECTORY;
    private static final Map<String, Object> SPECS;
    private final ResourceLocator locator;
    private Map<String, Connector> instances;
    private final ConnectorBuilder builder;

    public ConnectorBridgeSpi() {
        this(new ConnectorBuilderImpl());
    }

    public ConnectorBridgeSpi(ConnectorBuilder builder) {
        if (DIRECTORY == null) {
            this.locator = new ResourceLocatorClassImpl(Connector.class);
        } else {
            this.locator = new ResourceLocatorFileImpl(DIRECTORY);
            FileSystemObserver.watch(DIRECTORY.toPath(), this);
        }
        this.builder = builder;
        this.instances = Collections.emptyMap();
    }

    @Override
    public Connector load(String name) {
        return this.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connector get(String name) {
        Connector connector = this.instances.get(name);
        if (connector == null) {
            ConnectorBridgeSpi connectorBridgeSpi = this;
            synchronized (connectorBridgeSpi) {
                String resource;
                connector = this.instances.get(name);
                if (connector == null && (connector = this.load0(resource = name.concat(SUFFIX))) != null) {
                    LOGGER.trace("original: {}", this.instances);
                    HashMap<String, Connector> temp = new HashMap<String, Connector>(this.instances);
                    temp.put(name, connector);
                    LOGGER.trace("new: {}", temp);
                    this.instances = temp;
                }
            }
        }
        return connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connector load0(String file) {
        LOGGER2.info("Loading configuration: {}", (Object)file);
        try {
            Connector connector;
            InputStream inputStream = this.locator.open(file);
            if (inputStream == null) {
                LOGGER.warn("Not Found: {}", (Object)file);
                connector = null;
            } else {
                Map<String, Object> data;
                try {
                    data = this.checkSpecs(CodecCoupling.jsonCodecBridge().decodeMap(new InputStreamReader(inputStream, StandardCharsets.UTF_8)));
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        LOGGER.warn("when closing a resource", (Throwable)e);
                    }
                }
                LOGGER.trace("decoded: {}", data);
                connector = this.builder.build(data);
            }
            return connector;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    Map<String, Object> checkSpecs(Map<String, Object> data) {
        Map specs = (Map)data.get("specs");
        if (specs == null) {
            throw new IllegalArgumentException("no specs");
        }
        if (SPECS.equals(specs)) {
            return data;
        }
        throw new IllegalArgumentException("unsupported specs: ".concat(CodecCoupling.jsonCodecBridge().encode(specs)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDelete(Path directory, Path deleted) {
        String file = deleted.toString();
        if (file.endsWith(SUFFIX)) {
            LOGGER2.warn("Removing configuration definition: {}", (Object)deleted);
            String name = this.removeSufix(file);
            ConnectorBridgeSpi connectorBridgeSpi = this;
            synchronized (connectorBridgeSpi) {
                if (this.instances.containsKey(name)) {
                    HashMap<String, Connector> temp = new HashMap<String, Connector>(this.instances);
                    temp.remove(name);
                    this.instances = temp;
                }
            }
        } else {
            LOGGER.debug("ignore deleted file: {}", (Object)deleted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUpdate(Path directory, Path updated) {
        String file = updated.toString();
        if (file.endsWith(SUFFIX)) {
            LOGGER2.info("Change detected on configuration: {}", (Object)updated);
            String name = this.removeSufix(file);
            ConnectorBridgeSpi connectorBridgeSpi = this;
            synchronized (connectorBridgeSpi) {
                if (this.instances.containsKey(name)) {
                    HashMap<String, Connector> temp = new HashMap<String, Connector>(this.instances);
                    temp.put(name, this.load0(file));
                    this.instances = temp;
                }
            }
        } else {
            LOGGER2.warn("Ignored : {}", (Object)updated);
            LOGGER.debug("ignore updated file: {}", (Object)updated);
        }
    }

    String removeSufix(String name) {
        return name.substring(0, name.length() - 5);
    }

    static {
        assert (5 == SUFFIX.length());
        String temp = System.getProperty(ENVIRONMENT);
        if (temp == null || temp.isEmpty()) {
            temp = System.getenv(ENVIRONMENT);
            if (temp == null || temp.isEmpty()) {
                LOGGER.info("No DIRECTORY_CONNECTOR defined, using default");
                DIRECTORY = null;
            } else {
                LOGGER.info("using DIRECTORY_CONNECTOR (env): {}", (Object)temp);
                DIRECTORY = new File(temp);
            }
        } else {
            LOGGER.info("using DIRECTORY_CONNECTOR (prop): {}", (Object)temp);
            DIRECTORY = new File(temp);
        }
        HashMap<String, Object> spec = new HashMap<String, Object>();
        spec.put("kind", "connector");
        spec.put("format", "1.0");
        SPECS = spec;
    }
}

