package net.sf.aguacate.util.type;

import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Str {

	private static final String[] EMPTY = new String[0];

	private Str() {
	}

	@SuppressWarnings("unchecked")
	public static List<String> toList(Object object) {
		if (object == null) {
			return Collections.emptyList();
		} else {
			if (object instanceof List) {
				return (List<String>) object;
			} else {
				Class<?> klass = object.getClass();
				if (String.class == klass) {
					return Collections.singletonList((String) object);
				} else {
					throw new IllegalStateException(klass.getName());
				}
			}
		}
	}

	public static String[] toArray(Collection<String> list) {
		if (list == null || list.isEmpty()) {
			return EMPTY;
		} else {
			return list.toArray(new String[list.size()]);
		}
	}

}
