package net.sf.aguacate.util.type;

import java.math.BigDecimal;

public final class Flt {

	private Flt() {
	}

	public static BigDecimal parse(Object value) {
		if (value instanceof String) {
			return new BigDecimal((String) value);
		} else {
			if (value instanceof Float || value instanceof Double) {
				return BigDecimal.valueOf(((Number) value).doubleValue());
			} else {
				throw new IllegalArgumentException(value.getClass().getName());
			}
		}
	}

}
