package net.sf.aguacate.util.codec.bridge;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public interface CodecBridge {

	boolean support(String mimetype);

	String mimetype();

	Map<String, Object> decodeMap(Reader reader) throws IOException;

	Map<String, Object> decodeMap(String json) throws IOException;

	List<Object> decodeList(Reader reader) throws IOException;

	List<Object> decodeList(String json) throws IOException;

	Object decode(Reader reader) throws IOException;

	Object decode(String json) throws IOException;

	String encode(Object object);

	void encode(Writer writer, Object object) throws IOException;

}
