package net.sf.aguacate.function.spi.impl;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.function.FunctionEvalResult;
import net.sf.aguacate.function.spi.AbstractFunction;
import net.sf.aguacate.util.type.Str;

public class FunctionLiteralFloat extends AbstractFunction {

	private final String outputName;

	private final String[] outputContext;

	private final FunctionEvalResult result;

	private final String message;

	public FunctionLiteralFloat(Collection<String> methods, String name, String message, List<String> outputContext,
			String outputName, Object value) {
		super(methods, name);
		this.outputContext = Str.toArray(outputContext);
		this.outputName = outputName;
		this.result = new FunctionEvalResult(true, new BigDecimal((String) value));
		this.message = message;
	}

	@Override
	public FunctionEvalResult evaluate(FunctionContext functionContext, Map<String, Object> context) {
		logSuccess(MessageFormat.format(message, result.getData()));
		return result;
	}

	@Override
	public String[] getOutputContext() {
		return outputContext;
	}

	@Override
	public String getOutputName() {
		return outputName;
	}

}
