package net.sf.aguacate.function.spi.impl;

import java.util.Collection;

import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.function.FunctionEvalResult;
import net.sf.aguacate.function.spi.AbstractFunction1;
import net.sf.aguacate.util.parameter.Parameter;

public class FunctionBetween<T extends Comparable<T>> extends AbstractFunction1 {

	private final T lower;

	private final T upper;

	public FunctionBetween(Collection<String> methods, String name, String message, Parameter parameter, T lower,
			T upper) {
		super(methods, name, message, parameter);
		this.lower = lower;
		this.upper = upper;
	}

	@Override
	protected FunctionEvalResult evaluate(FunctionContext functionContext, String msg, Object value) {
		@SuppressWarnings("unchecked")
		T val = (T) value;
		if (lower.compareTo(val) >= 0) {
			logFailure(msg);
			return new FunctionEvalResult("minor or equals than lower", null);
		} else {
			if (upper.compareTo(val) <= 0) {
				logFailure(msg);
				return new FunctionEvalResult("greater or equals than upper", null);
			} else {
				logSuccess(msg);
				return new FunctionEvalResult(null, null);
			}
		}
	}

}
