package net.sf.aguacate.function;

public class FunctionEvalResult {

	private final boolean success;

	private final String message;

	private final Object data;

	public FunctionEvalResult(boolean success) {
		this(success, null, null);
	}

	public FunctionEvalResult(boolean success, Object data) {
		this(success, null, data);
	}

	public FunctionEvalResult(String message, Object data) {
		this(message == null, message, data);
	}

	public FunctionEvalResult(boolean success, String message, Object data) {
		this.message = message;
		this.data = data;
		this.success = success;
	}

	public String getMessage() {
		return message;
	}

	public Object getData() {
		return data;
	}

	public boolean isSuccess() {
		return success;
	}

}
