package net.sf.aguacate.field;

import java.util.Calendar;
import java.util.Date;

import net.sf.aguacate.validator.ValidationConversionResult;

final class FieldTimeUtil {

	private FieldTimeUtil() {
	}

	static int timeZone(String string) {
		int length = string.length();
		int pos = length - 1;
		if (string.charAt(pos) == 'Z') {
			return pos;
		} else {
			pos = length - 6;
			int c = string.charAt(pos);
			if ('-' == c || '+' == c) {
				return pos;
			} else {
				throw new IllegalArgumentException(string);
			}
		}
	}

	static ValidationConversionResult validate(Date min, Date date, Date max) {
		if (date.compareTo(min) < 0) {
			return new ValidationConversionResult("Invalid minimum value");
		} else {
			if (date.compareTo(max) > 0) {
				return new ValidationConversionResult("Invalid maximum value");
			} else {
				return new ValidationConversionResult(date);
			}
		}
	}

	/**
	 * "...+00:00" "...-00:00" "...Z"
	 */
	static int tzToMinutes(String string) {
		int length = string.length();
		if (string.charAt(length - 1) == 'Z') {
			return 0;
		} else {
			int hours = Integer.parseInt(string.substring(length - 5, length - 3));
			int mins = Integer.parseInt(string.substring(length - 2));
			int c = string.charAt(length - 6);
			if ('-' == c) {
				return -((hours * 60) + mins);
			} else {
				if ('+' == c) {
					return (hours * 60) + mins;
				} else {
					throw new IllegalArgumentException(string);
				}
			}
		}
	}

	static int diff(int source, int target) {
		return target - source;
	}

	static int calculateDiff(Calendar now, String ref) {
		int src = tzToMinutes(ref);
		int tgt = now.getTimeZone().getRawOffset() / (60 * 1_000);
		return diff(tgt, src);
	}

	static int calculateDiff(String ref, Calendar now) {
		int src = tzToMinutes(ref);
		int tgt = now.getTimeZone().getRawOffset() / (60 * 1_000);
		return diff(src, tgt);
	}

}
