package net.sf.aguacate.field;

import java.math.BigInteger;

import net.sf.aguacate.validator.ValidationConversionResult;

public class FieldInteger extends FieldNumber {

	private final BigInteger minValue;

	private final BigInteger maxValue;

	public FieldInteger(String name, boolean optional, String minValue, String maxValue) {
		super(name, Field.INTEGER, optional);
		this.minValue = new BigInteger(minValue);
		this.maxValue = new BigInteger(maxValue);
	}

	public BigInteger getMinValue() {
		return minValue;
	}

	public BigInteger getMaxValue() {
		return maxValue;
	}

	@Override
	public ValidationConversionResult validateAndConvert(Object value) {
		Class<?> klass = value.getClass();
		if (Integer.class == klass || Long.class == klass) {
			return validate(minValue, BigInteger.valueOf(((Number) value).longValue()), maxValue);
		} else {
			if (String.class == klass) {
				try {
					return validate(minValue, new BigInteger((String) value), maxValue);
				} catch (NumberFormatException e) {
					return new ValidationConversionResult("Invalid format");
				}
			} else {
				return new ValidationConversionResult("Invalid value");
			}
		}
	}

}
