package net.sf.aguacate.field;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.sf.aguacate.validator.ValidationConversionResult;

/**
 * <pre>
 * "field": {
 *   "type": "ARRAY",
 *   "unique": ...,
 *   "data": {
 *     "type": "INTEGER"
 *     "minval": ...,
 *     "maxval": ...
 *   }
 * }
 * </pre>
 */
public class FieldArray extends Field {

	private final String contextName;

	private final Field field;

	private final boolean unique;

	public FieldArray(String name, boolean optional, String contextName, Field field, boolean unique) {
		super(name, Field.ARRAY, optional);
		this.contextName = contextName;
		this.field = field;
		this.unique = unique;
	}

	@Override
	public ValidationConversionResult validateAndConvert(Object value) {
		if (value instanceof List) {
			@SuppressWarnings("unchecked")
			List<Object> list = (List<Object>) value;
			int size = list.size();
			List<Object> result = new ArrayList<>(size);
			for (int i = 0; i < size; i++) {
				ValidationConversionResult temp = field.validateAndConvert(list.get(i));
				if (temp.isSuccess()) {
					Map<String, Object> sub = new HashMap<>();
					sub.put(contextName, temp.getValue());
					if (unique && result.contains(sub)) {
						return new ValidationConversionResult("duplicate value");
					} else {
						result.add(sub);
					}
				} else {
					return temp;
				}
			}
			return new ValidationConversionResult(result);
		} else {
			throw new IllegalStateException(value.getClass().getName());
		}
	}

}
