package net.sf.aguacate.effort;

import java.util.Iterator;
import java.util.ServiceLoader;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EffortDefinitionCoupling {

	private static final Logger LOGGER = LogManager.getLogger(EffortDefinitionCoupling.class);

	private static final EffortDefinitionLoader LOADER;

	static {
		Iterator<EffortDefinitionLoader> iterator = ServiceLoader.load(EffortDefinitionLoader.class).iterator();
		if (iterator.hasNext()) {
			LOADER = iterator.next();
			if (iterator.hasNext()) {
				LOGGER.warn("Unused instance {}", iterator.next().getClass().getName());
			}
		} else {
			throw new IllegalStateException("No definition for:" + EffortDefinitionCoupling.class.getName());
		}
	}

	public static Effort get(String name) {
		return LOADER.get(name);
	}

}
