package net.sf.aguacate.definition;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.util.config.database.DatabaseBridge;
import net.sf.aguacate.util.config.database.DatabaseInterface;
import net.sf.aguacate.util.environment.EnvironmentCoupling;

public class FunctionContextDefinition implements FunctionContext {

	private static final Logger LOGGER = LogManager.getLogger(FunctionContextDefinition.class);

	private final DatabaseBridge databaseBridge;

	private Connection connection;

	public FunctionContextDefinition(DatabaseBridge databaseBridge) {
		this.databaseBridge = databaseBridge;
	}

	@Override
	public DatabaseInterface databaseInterface() {
		return databaseBridge.getDatabaseInterface();
	}

	@Override
	public String getMethod() {
		throw new UnsupportedOperationException();
	}

	@Override
	public Connection acquireConnection() throws SQLException {
		if (connection == null) {
			connection = databaseBridge.getDataSource().getConnection();
		}
		return connection;
	}

	@Override
	public Map<String, Object> get(String name) {
		return EnvironmentCoupling.get(name);
	}

	@Override
	public void rollback() {
		try {
			connection.rollback();
		} catch (SQLException e) {
			throw new IllegalStateException(e);
		}
	}

	@Override
	public void close() {
		if (connection != null) {
			Connection temp = connection;
			connection = null;
			try {
				temp.close();
			} catch (SQLException e) {
				LOGGER.warn("On close connection", temp);
			}
		}
	}

	@Override
	public void handleNotFound() {
	}

	@Override
	public void handleEmpty() {
	}

	@Override
	public void handleOk(Object object) {
	}

}
