package net.sf.aguacate.context.spi.sql.impl;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.function.FunctionEvalResult;
import net.sf.aguacate.util.parameter.Parameter;
import net.sf.aguacate.util.parameter.Prm;
import net.sf.aguacate.util.type.Str;

public class SentenceSqlSelectMultipleRow extends AbstractSentenceSql {

	private final String table;

	private final Parameter[] required;

	private final Parameter[] optional;

	private final String[] outputContext;

	private final String outputName;

	public SentenceSqlSelectMultipleRow(String name, String message, String table, List<String> methods,
			List<Parameter> required, List<Parameter> optional, List<String> outputContext, String outputName) {
		super(name, message, methods);
		this.table = table;
		this.required = Prm.toArray(required);
		this.optional = Prm.toArray(optional);
		this.outputContext = Str.toArray(outputContext);
		this.outputName = outputName;
	}

	@Override
	public FunctionEvalResult evaluate0(FunctionContext functionContext, Map<String, Object> context)
			throws SQLException {
		return new FunctionEvalResult(true, functionContext.databaseInterface().executeSelectMultipleRow(getName(),
				getMessage(), functionContext.acquireConnection(), table, context, required, optional));
	}

	@Override
	public String getOutputName() {
		return outputName;
	}

	@Override
	public String[] getOutputContext() {
		return outputContext;
	}

}
