package net.sf.aguacate.context;

import java.util.List;
import java.util.Map;

import net.sf.aguacate.function.FunctionEvalResult;

public class ContextValidationResult {

	private final List<FunctionEvalResult> errors;

	private final Map<String, Object> context;

	public ContextValidationResult(List<FunctionEvalResult> errors, Map<String, Object> context) {
		this.errors = errors;
		this.context = context;
	}

	public boolean isSuccess() {
		return errors == null || errors.isEmpty();
	}

	public List<FunctionEvalResult> getErrors() {
		return errors;
	}

	public Map<String, Object> getContext() {
		return context;
	}

}
