package net.sf.aguacate.connector.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import net.sf.aguacate.connector.Connector;
import net.sf.aguacate.util.type.Bool;

public class ConnectorBuilderImpl implements ConnectorBuilder {

	private static final Logger LOGGER = LogManager.getFormatterLogger(ConnectorBuilderImpl.class);

	@SuppressWarnings("unchecked")
	@Override
	public Connector build(Map<String, Object> data) {
		LOGGER.trace(data);
		String protocol = (String) data.get("protocol");
		Connector connector;
		switch (protocol) {
		case "http": {
			String method = (String) data.get("method");
			switch (method) {
			case "GET":
				connector = new ConnectorHttpGet((String) data.get("base"), (String) data.get("expectedMimetype"),
						(Map<String, String>) data.get("headers"), toParameters(data.get("parameters")));
				break;
			default:
				throw new IllegalArgumentException(method);
			}
			break;
		}
		default:
			throw new IllegalArgumentException(protocol);
		}
		return connector;
	}

	@SuppressWarnings("unchecked")
	Collection<ConnectorHttpParameter> toParameters(Object source) {
		if (source instanceof Collection) {
			List<Object> list = (List<Object>) source;
			int size = list.size();
			Collection<ConnectorHttpParameter> result = new ArrayList<ConnectorHttpParameter>(size);
			for (int i = 0; i < size; i++) {
				Object current = list.get(i);
				if (current instanceof Map) {
					Map<String, Object> map = (Map<String, Object>) current;
					Map<String, Object> query = (Map<String, Object>) map.get("query");
					Map<String, Object> body = (Map<String, Object>) map.get("body");
					boolean inQuery = query != null;
					boolean inBody = body != null;
					boolean mandatoryInBody;
					if (inBody) {
						mandatoryInBody = Bool.valueOf(body.get("optional"));
					} else {
						mandatoryInBody = false;
					}
					boolean mandatoryInQuery;
					if (inQuery) {
						mandatoryInQuery = Bool.valueOf(query.get("optional"));
					} else {
						mandatoryInQuery = false;
					}
					result.add(new ConnectorHttpParameter((String) map.get("name"), inQuery, mandatoryInQuery, inBody,
							mandatoryInBody));
				} else {
					throw new IllegalArgumentException(current.getClass().getName());
				}
			}
			return result;
		} else {
			throw new IllegalArgumentException(source.getClass().getName());
		}
	}

}
