package net.sf.aguacate.check.impl;

import java.util.Collection;
import java.util.Map;

import net.sf.aguacate.check.Check;

public class CheckNotNullAndNotEmpty implements Check {

	@Override
	public boolean test(Object value) {
		if (value == null) {
			return false;
		} else {
			if (value instanceof Map) {
				return !((Map<?, ?>) value).isEmpty();
			} else {
				if (value instanceof Collection) {
					return !((Collection<?>) value).isEmpty();
				} else {
					Class<?> klass = value.getClass();
					if (String.class == klass) {
						return !((String) value).isEmpty();
					} else {
						throw new IllegalArgumentException(klass.getName());
					}
				}
			}
		}
	}

}
