package net.sf.aguacate.check;

import java.util.HashMap;
import java.util.Map;

import net.sf.aguacate.check.impl.CheckNotNull;
import net.sf.aguacate.check.impl.CheckNotNullAndNotEmpty;
import net.sf.aguacate.check.impl.CheckNull;
import net.sf.aguacate.check.impl.CheckNullOrEmpty;

public final class CheckCoupling {

	private static final Map<String, Check> CHECKS;

	static {
		Map<String, Check> checks = new HashMap<>();
		checks.put("NOT_NULL", new CheckNotNull());
		checks.put("NULL", new CheckNull());
		checks.put("NULL_OR_EMPTY", new CheckNullOrEmpty());
		checks.put("NOT_NULL_AND_NOT_EMPTY", new CheckNotNullAndNotEmpty());
		CHECKS = checks;
	}

	private CheckCoupling() {
	}

	public static Check get(String name) {
		Check check = CHECKS.get(name);
		if (check == null) {
			throw new IllegalArgumentException(name);
		} else {
			return check;
		}
	}

}
