/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.util.http.bridge.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import net.sf.aguacate.util.codec.bridge.CodecBridge;
import net.sf.aguacate.util.http.bridge.HttpBridge;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpBridgeHttpClient
implements HttpBridge {
    private static final Logger LOGGER = LogManager.getLogger(HttpBridgeHttpClient.class);
    private static final CloseableHttpClient CLIENT = HttpClients.createDefault();

    @Override
    public Object readMapFromGet(URI uri, CodecBridge codec) throws IOException {
        return this.readMapFromMethod((HttpUriRequest)new HttpGet(uri), codec);
    }

    @Override
    public Object readMapFromGet(URI uri, Map<String, String> headers, CodecBridge codec) throws IOException {
        return this.readMapFromMethod((HttpUriRequest)this.addHeaders(new HttpGet(uri), headers), codec);
    }

    @Override
    public Object readListFromGet(URI uri, CodecBridge codec) throws IOException {
        return this.readListFromGet((HttpUriRequest)new HttpGet(uri), codec);
    }

    @Override
    public Object readListFromGet(URI uri, Map<String, String> headers, CodecBridge codec) throws IOException {
        return this.readListFromGet((HttpUriRequest)this.addHeaders(new HttpGet(uri), headers), codec);
    }

    @Override
    public Object readFromGet(URI uri, CodecBridge codec) throws IOException {
        return this.readFromGet(new HttpGet(uri), codec);
    }

    @Override
    public Object readFromGet(URI uri, Map<String, String> headers, CodecBridge codec) throws IOException {
        return this.readFromGet(this.addHeaders(new HttpGet(uri), headers), codec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object readMapFromMethod(HttpUriRequest request, CodecBridge codec) throws IOException, ClientProtocolException {
        CloseableHttpResponse response = CLIENT.execute(request);
        try {
            StatusLine statusLine = response.getStatusLine();
            if (statusLine == null) {
                throw new IllegalStateException("No status line");
            }
            int statusCode = statusLine.getStatusCode();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("{}: {}({})", (Object)request.getURI(), (Object)statusCode, (Object)statusLine.getReasonPhrase());
            }
            if (200 == statusCode) {
                HttpEntity entity = response.getEntity();
                ContentType contentType = ContentType.get((HttpEntity)entity);
                if (contentType == null) {
                    throw new IllegalStateException("No Content-Type line");
                }
                if (codec.support(contentType.getMimeType())) {
                    Reader reader = this.reader(entity, contentType, StandardCharsets.UTF_8);
                    try {
                        Map<String, Object> map = codec.decodeMap(reader);
                        return map;
                    }
                    finally {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            LOGGER.warn("On closing inputStream from HttpResponse", (Throwable)e);
                        }
                    }
                }
                throw new IllegalArgumentException(contentType.getMimeType());
            }
            Integer n = statusCode;
            return n;
        }
        finally {
            try {
                response.close();
            }
            catch (IOException e) {
                LOGGER.warn("On closing HttpResponse", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object readListFromGet(HttpUriRequest request, CodecBridge codec) throws IOException, ClientProtocolException {
        CloseableHttpResponse response = CLIENT.execute(request);
        try {
            StatusLine statusLine = response.getStatusLine();
            if (statusLine == null) {
                throw new IllegalStateException("No status line");
            }
            int statusCode = statusLine.getStatusCode();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("{}: {}({})", (Object)request.getURI(), (Object)statusCode, (Object)statusLine.getReasonPhrase());
            }
            if (200 == statusCode) {
                HttpEntity entity = response.getEntity();
                ContentType contentType = ContentType.get((HttpEntity)entity);
                if (contentType == null) {
                    throw new IllegalStateException("No Content-Type line");
                }
                if (codec.support(contentType.getMimeType())) {
                    Reader reader = this.reader(entity, contentType, StandardCharsets.UTF_8);
                    try {
                        List<Object> list = codec.decodeList(reader);
                        return list;
                    }
                    finally {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            LOGGER.warn("On closing inputStream from HttpResponse", (Throwable)e);
                        }
                    }
                }
                throw new IllegalArgumentException(contentType.getMimeType());
            }
            Integer n = statusCode;
            return n;
        }
        finally {
            try {
                response.close();
            }
            catch (IOException e) {
                LOGGER.warn("On closing HttpResponse", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readFromGet(HttpGet request, CodecBridge codec) throws IOException, ClientProtocolException {
        CloseableHttpResponse response = CLIENT.execute((HttpUriRequest)request);
        try {
            StatusLine statusLine = response.getStatusLine();
            if (statusLine == null) {
                throw new IllegalStateException("No status line");
            }
            int statusCode = statusLine.getStatusCode();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("{}: {}({})", (Object)request.getURI(), (Object)statusCode, (Object)statusLine.getReasonPhrase());
            }
            if (200 == statusCode) {
                HttpEntity entity = response.getEntity();
                ContentType contentType = ContentType.get((HttpEntity)entity);
                if (contentType == null) {
                    throw new IllegalStateException("No Content-Type line");
                }
                if (codec.support(contentType.getMimeType())) {
                    Reader reader = this.reader(entity, contentType, StandardCharsets.UTF_8);
                    try {
                        Object object = codec.decode(reader);
                        return object;
                    }
                    finally {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            LOGGER.warn("On closing inputStream from HttpResponse", (Throwable)e);
                        }
                    }
                }
                throw new IllegalArgumentException(contentType.getMimeType());
            }
            Integer n = statusCode;
            return n;
        }
        finally {
            try {
                response.close();
            }
            catch (IOException e) {
                LOGGER.warn("On closing HttpResponse", (Throwable)e);
            }
        }
    }

    Reader reader(HttpEntity entity, ContentType contentType, Charset defaultCharset) throws IOException {
        InputStream inputStream = entity.getContent();
        if (inputStream == null) {
            throw new IllegalStateException("No content");
        }
        Charset temp = contentType.getCharset();
        LOGGER.debug("charset from server: {}", (Object)temp);
        Charset charSet = temp == null ? defaultCharset : temp;
        return new InputStreamReader(inputStream, charSet);
    }

    <T extends HttpMessage> T addHeaders(T message, Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            message.addHeader(entry.getKey(), entry.getValue());
        }
        return message;
    }
}

