/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.function.spi.impl;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.function.FunctionEvalResult;
import net.sf.aguacate.function.spi.AbstractFunction;
import net.sf.aguacate.util.parameter.Parameter;
import net.sf.aguacate.util.type.Str;

public class FunctionCopy
extends AbstractFunction {
    private final String message;
    private final String[] outputContext;
    private final String outputName;
    private final Parameter parameter;

    public FunctionCopy(Collection<String> methods, String name, String message, Parameter parameter, List<String> outputContext, String outputName) {
        super(methods, name);
        this.message = message;
        this.outputContext = Str.toArray(outputContext);
        this.outputName = outputName;
        this.parameter = parameter;
    }

    @Override
    public FunctionEvalResult evaluate(FunctionContext functionContext, Map<String, Object> context) {
        String from = this.parameter.getFrom();
        Map<String, Object> initial = from == null ? context : functionContext.get(from);
        Object value = this.parameter.calculateContext(initial).get(this.parameter.getName());
        String msg = MessageFormat.format(this.message, value);
        this.logSuccess(msg);
        return new FunctionEvalResult(true, value);
    }

    @Override
    public String getOutputName() {
        return this.outputName;
    }

    @Override
    public String[] getOutputContext() {
        return this.outputContext;
    }
}

