/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.field;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.aguacate.field.Field;
import net.sf.aguacate.validator.ValidationConversionResult;

public class FieldArray
extends Field {
    private final String contextName;
    private final Field field;
    private final boolean unique;

    public FieldArray(String name, boolean optional, String contextName, Field field, boolean unique) {
        super(name, "ARRAY", optional);
        this.contextName = contextName;
        this.field = field;
        this.unique = unique;
    }

    @Override
    public ValidationConversionResult validateAndConvert(Object value) {
        if (value instanceof List) {
            List list = (List)value;
            int size = list.size();
            ArrayList result = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                HashMap<String, Object> sub;
                ValidationConversionResult temp = this.field.validateAndConvert(list.get(i));
                if (temp.isSuccess()) {
                    sub = new HashMap<String, Object>();
                    sub.put(this.contextName, temp.getValue());
                    if (this.unique && result.contains(sub)) {
                        return new ValidationConversionResult("duplicate value");
                    }
                } else {
                    return temp;
                }
                result.add(sub);
            }
            return new ValidationConversionResult(result);
        }
        throw new IllegalStateException(value.getClass().getName());
    }
}

