/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.connector.spi;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.aguacate.connector.Connector;
import net.sf.aguacate.connector.spi.ConnectorHttpParameter;
import net.sf.aguacate.connector.spi.ConnectorHttpParameterComparator;
import net.sf.aguacate.connector.spi.ConnectorHttpParameterComparatorAlt;
import net.sf.aguacate.util.codec.bridge.CodecBridge;
import org.apache.http.client.utils.URIBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ConnectorHttp
implements Connector {
    private static final Logger LOGGER = LogManager.getLogger(ConnectorHttp.class);
    private static final Logger LOGGER2 = LogManager.getLogger((String)"aguacate.net.http");
    private static final ConnectorHttpParameterComparator PARAMETER_COMPARATOR = new ConnectorHttpParameterComparator();
    private static final ConnectorHttpParameterComparatorAlt PARAMETER_COMPARATOR_ALT = new ConnectorHttpParameterComparatorAlt();
    private final boolean acceptsBody;
    private final String base;
    private final String expectedMimeType;
    private final Map<String, String> headers;
    private final ConnectorHttpParameter[] httpParameters;

    public ConnectorHttp(boolean acceptsBody, String base, String expectedMimeType, Map<String, String> headers, Collection<ConnectorHttpParameter> parameters) {
        if (!base.startsWith("http://") && !base.startsWith("https://")) {
            throw new IllegalArgumentException(base);
        }
        this.acceptsBody = acceptsBody;
        this.base = base;
        this.expectedMimeType = expectedMimeType;
        this.headers = headers;
        this.httpParameters = parameters.toArray(new ConnectorHttpParameter[parameters.size()]);
        Arrays.sort(this.httpParameters, PARAMETER_COMPARATOR);
    }

    @Override
    public Object execute(Map<String, Object> parameters) {
        try {
            LOGGER.trace(parameters);
            CodecBridge codec = this.getCodecBridge(this.expectedMimeType);
            URIBuilder builder = new URIBuilder(this.base);
            LinkedHashMap<String, Object> body = this.acceptsBody ? new LinkedHashMap<String, Object>() : null;
            int length = this.httpParameters.length;
            boolean[] found = new boolean[length];
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                String name = parameter.getKey();
                int ndx = Arrays.binarySearch(this.httpParameters, name, PARAMETER_COMPARATOR_ALT);
                if (ndx >= 0) {
                    found[ndx] = true;
                    ConnectorHttpParameter httpParameter = this.httpParameters[ndx];
                    Object value = parameter.getValue();
                    if (httpParameter.isInQuery()) {
                        if (value == null) {
                            builder.addParameter(name, "");
                        } else {
                            builder.addParameter(name, String.valueOf(value));
                        }
                    }
                    if (!httpParameter.isInBody()) continue;
                    body.put(name, value);
                    continue;
                }
                throw new IllegalArgumentException(name);
            }
            for (int i = 0; i < length; ++i) {
                if (found[i]) continue;
                String name = this.httpParameters[i].getName();
                LOGGER.warn("Missing configuration for parameter: {} ({} & {})", (Object)name, (Object)builder, body);
                throw new IllegalStateException(name);
            }
            URI uri = builder.build();
            LOGGER2.info("build: {}", (Object)uri);
            return this.execute0(uri, this.headers, codec);
        }
        catch (IOException | URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    protected abstract CodecBridge getCodecBridge(String var1);

    protected abstract Object execute0(URI var1, Map<String, String> var2, CodecBridge var3) throws IOException;
}

