package net.sf.aguacate.validator;

public class ValidationConversionResult {

	private final String message;

	private final Object value;

	public ValidationConversionResult(Object value) {
		this(null, value);
	}

	public ValidationConversionResult(String message) {
		this(message, null);
	}

	ValidationConversionResult(String message, Object value) {
		this.message = message;
		this.value = value;
	}

	public boolean isSuccess() {
		return message == null;
	}

	public String getMessage() {
		return message;
	}

	public Object getValue() {
		return value;
	}

}
