package net.sf.aguacate.util.resource.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import net.sf.aguacate.util.resource.ResourceLocator;

public class ResourceLocatorFileImpl implements ResourceLocator {

	private static final Logger LOGGER = LogManager.getLogger(ResourceLocatorFileImpl.class);

	private final File directory;

	public ResourceLocatorFileImpl(String directory) {
		this(new File(directory));
	}

	public ResourceLocatorFileImpl(File directory) {
		this.directory = directory;
	}

	@Override
	public String[] list(String suffix) {
		return directory.list(new FilenameFilter() {
			@Override
			public boolean accept(File dir, String name) {
				return name.endsWith(suffix);
			}
		});
	}

	@Override
	public InputStream open(String resource) throws IOException {
		File file = new File(directory, resource);
		LOGGER.debug("file to open: {}", file);
		if (file.exists()) {
			return new FileInputStream(file);
		} else {
			return null;
		}
	}

}
