package net.sf.aguacate.util.dynamic.bridge.spi;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

import net.sf.aguacate.util.dynamic.bridge.Dynamic;

public class DynamicScript implements Dynamic {

	private final ScriptEngine engine;

	private final Invocable invocable;

	private final CompiledScript compiled;

	public DynamicScript(ScriptEngine engine, Invocable invocable, CompiledScript compiled) {
		this.engine = engine;
		this.invocable = invocable;
		this.compiled = compiled;
	}

	@Override
	public Map<String, Object> mapExec(String name, Object... args) {
		try {
			Bindings bindings = new SimpleBindings();
			return ScriptUtil.unwrapMap(engine, invocable, bindings,
					invocable.invokeMethod(compiled.eval(bindings), name, args));
		} catch (NoSuchMethodException | ScriptException | IOException e) {
			throw new IllegalStateException(e);
		}
	}

	@Override
	public List<Object> listExec(String name, Object... args) {
		try {
			Bindings bindings = new SimpleBindings();
			return ScriptUtil.unwrapList(engine, invocable, bindings,
					invocable.invokeMethod(compiled.eval(bindings), name, args));
		} catch (NoSuchMethodException | ScriptException | IOException e) {
			throw new IllegalStateException(e);
		}
	}

	@Override
	public Object exec(String name, Object... args) {
		try {
			Bindings bindings = new SimpleBindings();
			return ScriptUtil.unwrap(engine, invocable, bindings,
					invocable.invokeMethod(compiled.eval(bindings), name, args));
		} catch (NoSuchMethodException | ScriptException | IOException e) {
			throw new IllegalStateException(e);
		}
	}

	@Override
	public <T> T typedExec(String name, Object... args) {
		try {
			Bindings bindings = new SimpleBindings();
			return ScriptUtil.unwrap(engine, invocable, bindings,
					invocable.invokeMethod(compiled.eval(bindings), name, args));
		} catch (NoSuchMethodException | ScriptException | IOException e) {
			throw new IllegalStateException(e);
		}
	}

}
