package net.sf.aguacate.scheduler;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class InternalSchedulerCoupling {

	private static final Timer TIMER;

	private static final ExecutorService EXECUTOR;

	private static final List<InternalTask> TASKS;

	static {
		TIMER = new Timer();
		List<InternalTask> tasks = new ArrayList<>();
		for (InternalTask instance : ServiceLoader.load(InternalTask.class)) {
			tasks.add(instance);
		}
		TASKS = tasks;
		int size = tasks.size();
		if (size > 0) {
			EXECUTOR = new ThreadPoolExecutor(1, 10, 5, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(10));
		} else {
			EXECUTOR = null;
		}
	}

	public static void start() {
		int size = TASKS.size();
		for (int i = 0; i < size; i++) {
			InternalTask task = TASKS.get(i);
			TIMER.scheduleAtFixedRate(new TimerTask() {
				private final Runnable runnable = new Runnable() {
					@Override
					public void run() {
						task.execute();
					}
				};

				@Override
				public void run() {
					EXECUTOR.execute(runnable);
				}
			}, 0, task.getPeriod());
		}
	}

	public static void stop() {
		TIMER.cancel();
		if (EXECUTOR != null) {
			EXECUTOR.shutdown();
		}
	}

}
