package net.sf.aguacate.regex.spi.script;

import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptException;

import net.sf.aguacate.regex.Regex;

public class RegexScriptEngineJs implements Regex {

	private final Invocable invocable;

	private final CompiledScript compiled;

	public RegexScriptEngineJs(Invocable invocable, CompiledScript compiled) {
		this.invocable = invocable;
		this.compiled = compiled;
	}

	@Override
	public boolean matches(String value) {
		try {
			Object result = invocable.invokeMethod(compiled.eval(), "test", value);
			Class<? extends Object> klass = result.getClass();
			if (Boolean.class == klass) {
				return ((Boolean) result).booleanValue();
			} else {
				throw new IllegalStateException(klass.getName());
			}
		} catch (NoSuchMethodException | ScriptException e) {
			throw new IllegalStateException(e);
		}
	}

}
