package net.sf.aguacate.function.spi.impl;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.text.StringSubstitutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.function.FunctionEvalResult;
import net.sf.aguacate.function.spi.AbstractFunction;
import net.sf.aguacate.util.parameter.Parameter;
import net.sf.aguacate.util.parameter.Prm;
import net.sf.aguacate.util.type.Str;

public class FunctionStringSubstitutor extends AbstractFunction {

	private static final Logger LOGGER = LogManager.getLogger(FunctionStringSubstitutor.class);

	private final String message;

	private final Parameter parameter;

	private final Parameter[] parameters;

	private final String[] outputContext;

	private final String outputName;

	public FunctionStringSubstitutor(Collection<String> methods, String name, String message, Parameter parameter,
			List<Parameter> optionals, Collection<String> outputContext, String outputName) {
		super(methods, name);
		this.message = message;
		this.parameter = parameter;
		this.parameters = Prm.toArray(optionals);
		this.outputContext = Str.toArray(outputContext);
		this.outputName = outputName;
	}

	@Override
	public FunctionEvalResult evaluate(FunctionContext functionContext, Map<String, Object> context) {
		String source = (String) parameter.calculateContext(context).get(parameter.getName());
		Map<String, Object> valueMap = new LinkedHashMap<>();
		for (Parameter p : parameters) {
			valueMap.put(p.getAliasOf(), p.calculateContext(context).get(p.getName()));
		}
		LOGGER.trace("{},{}", source, valueMap);
		StringSubstitutor substitutor = new StringSubstitutor(valueMap);
		substitutor.setEnableUndefinedVariableException(true);
		substitutor.setEnableSubstitutionInVariables(false);
		try {
			String result = substitutor.replace(source);
			if (result == null) {
				logFailure(message);
				return FAILURE;
			} else {
				logSuccess(message);
				return new FunctionEvalResult(true, result);
			}
		} catch (IllegalArgumentException e) {
			logFailure(message);
			return new FunctionEvalResult(false, e.getMessage(), null);
		}
	}

	@Override
	public String[] getOutputContext() {
		return outputContext;
	}

	@Override
	public String getOutputName() {
		return outputName;
	}

}
