package net.sf.aguacate.function.spi.impl;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.function.FunctionEvalResult;
import net.sf.aguacate.function.spi.AbstractFunction;
import net.sf.aguacate.util.parameter.Parameter;
import net.sf.aguacate.util.type.Str;

public class FunctionRename extends AbstractFunction {

	private final String message;

	private final String[] outputContext;

	private final String outputName;

	private final Parameter parameter;

	public FunctionRename(Collection<String> methods, String name, String message, Parameter parameter,
			List<String> outputContext, String outputName) {
		super(methods, name);
		this.message = message;
		this.outputContext = Str.toArray(outputContext);
		this.outputName = outputName;
		this.parameter = parameter;
	}

	@Override
	public FunctionEvalResult evaluate(FunctionContext functionContext, Map<String, Object> context) {
		Object value = parameter.calculateContext(context).remove(parameter.getName());
		String msg = MessageFormat.format(message, value);
		logSuccess(msg);
		return new FunctionEvalResult(true, value);
	}

	@Override
	public String getOutputName() {
		return outputName;
	}

	@Override
	public String[] getOutputContext() {
		return outputContext;
	}

}
