package net.sf.aguacate.function.spi.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;

import net.sf.aguacate.function.FunctionEvalResult;
import net.sf.aguacate.function.spi.AbstractFunction2;
import net.sf.aguacate.util.parameter.Parameter;
import net.sf.aguacate.util.type.Str;

public class FunctionMultiply extends AbstractFunction2 {

	private final String[] outputContext;

	private final String outputName;

	public FunctionMultiply(Collection<String> methods, String name, String message, Parameter parameter1,
			Parameter parameter2, List<String> outputContext, String outputName) {
		super(methods, name, message, parameter1, parameter2);
		this.outputContext = Str.toArray(outputContext);
		this.outputName = outputName;
	}

	@Override
	protected FunctionEvalResult evaluate(String msg, Object value1, Object value2) {
		Number result;
		if (value1 instanceof BigDecimal) {
			if (value2 instanceof BigDecimal) {
				BigDecimal number1 = (BigDecimal) value1;
				BigDecimal number2 = (BigDecimal) value2;
				BigDecimal temp = number1.multiply(number2);
				int scale1 = number1.scale();
				int scale2 = number2.scale();
				if (scale1 >= scale2) {
					result = temp.setScale(scale1, BigDecimal.ROUND_HALF_UP);
				} else {
					result = temp.setScale(scale2, BigDecimal.ROUND_HALF_UP);
				}
			} else {
				if (value2 instanceof BigInteger) {
					result = ((BigDecimal) value1).multiply(new BigDecimal((BigInteger) value2));
				} else {
					if (value2 instanceof Number) {
						result = ((BigDecimal) value1).multiply(new BigDecimal(((Number) value2).longValue()));
					} else {
						logFailure(msg);
						return FAILURE;
					}
				}
			}
		} else {
			if (value1 instanceof BigInteger) {
				if (value2 instanceof BigDecimal) {
					result = new BigDecimal((BigInteger) value1).multiply((BigDecimal) value2);
				} else {
					if (value2 instanceof BigInteger) {
						result = ((BigInteger) value1).multiply((BigInteger) value2);
					} else {
						if (value2 instanceof Number) {
							result = ((BigInteger) value1).multiply(BigInteger.valueOf(((Number) value2).longValue()));
						} else {
							logFailure(msg);
							return FAILURE;
						}
					}
				}
			} else {
				if (value1 instanceof Number) {
					if (value2 instanceof BigDecimal) {
						result = new BigDecimal(((Number) value1).longValue()).multiply((BigDecimal) value2);
					} else {
						if (value2 instanceof BigInteger) {
							result = BigInteger.valueOf(((Number) value1).longValue()).multiply((BigInteger) value2);
						} else {
							if (value2 instanceof Number) {
								result = ((Number) value1).longValue() * ((Number) value2).longValue();
							} else {
								logFailure(msg);
								return FAILURE;
							}
						}
					}
				} else {
					logFailure(msg);
					return FAILURE;
				}
			}
		}
		logSuccess(msg);
		return new FunctionEvalResult(true, result);
	}

	@Override
	public String getOutputName() {
		return outputName;
	}

	@Override
	public String[] getOutputContext() {
		return outputContext;
	}

}
