package net.sf.aguacate.function.spi.impl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;

import org.apache.commons.codec.binary.Hex;

import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.function.FunctionEvalResult;
import net.sf.aguacate.function.spi.AbstractFunction1;
import net.sf.aguacate.util.parameter.Parameter;
import net.sf.aguacate.util.type.Str;

public class FunctionHash extends AbstractFunction1 {

	private final String algorithm;

	private final String[] outputContext;

	private final String outputName;

	public FunctionHash(String algorithm, Collection<String> methods, String name, String message, Parameter parameter,
			Collection<String> outputContext, String outputName) {
		super(methods, name, message, parameter);
		this.algorithm = algorithm;
		this.outputContext = Str.toArray(outputContext);
		this.outputName = outputName;
	}

	@Override
	protected FunctionEvalResult evaluate(FunctionContext functionContext, String msg, Object value) {
		try {
			return new FunctionEvalResult(true,
					Hex.encodeHexString(MessageDigest.getInstance(algorithm).digest((byte[]) value)));
		} catch (NoSuchAlgorithmException e) {
			throw new IllegalStateException(e);
		}
	}

	@Override
	public String[] getOutputContext() {
		return outputContext;
	}

	@Override
	public String getOutputName() {
		return outputName;
	}

}
