package net.sf.aguacate.function.spi.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;

import net.sf.aguacate.function.FunctionEvalResult;
import net.sf.aguacate.function.spi.AbstractFunction2;
import net.sf.aguacate.util.parameter.Parameter;
import net.sf.aguacate.util.type.Str;

public class FunctionDivide extends AbstractFunction2 {

	private final String[] outputContext;

	private final String outputName;

	public FunctionDivide(Collection<String> methods, String name, String message, Parameter parameter1,
			Parameter parameter2, List<String> outputContext, String outputName) {
		super(methods, name, message, parameter1, parameter2);
		this.outputContext = Str.toArray(outputContext);
		this.outputName = outputName;
	}

	@Override
	protected FunctionEvalResult evaluate(String msg, Object value1, Object value2) {
		Number result;
		if (value1 instanceof BigDecimal) {
			if (value2 instanceof BigDecimal) {
				BigDecimal first = (BigDecimal) value1;
				BigDecimal second = (BigDecimal) value2;
				int scale1 = first.scale();
				int scale2 = second.scale();
				if (scale1 > scale2) {
					second = second.setScale(scale1);
				} else {
					if (scale2 > scale1) {
						first = first.setScale(scale2);
					}
				}
				result = first.divide(second, BigDecimal.ROUND_HALF_UP);
			} else {
				if (value2 instanceof BigInteger) {
					result = ((BigDecimal) value1).divide(new BigDecimal((BigInteger) value2),
							BigDecimal.ROUND_HALF_UP);
				} else {
					if (value2 instanceof Number) {
						result = ((BigDecimal) value1).divide(new BigDecimal(((Number) value2).longValue()),
								BigDecimal.ROUND_HALF_UP);
					} else {
						logFailure(msg);
						return FAILURE;
					}
				}
			}
		} else {
			if (value1 instanceof BigInteger) {
				if (value2 instanceof BigDecimal) {
					BigDecimal second = (BigDecimal) value2;
					result = new BigDecimal((BigInteger) value1).setScale(second.scale()).divide(second,
							BigDecimal.ROUND_HALF_UP);
				} else {
					if (value2 instanceof BigInteger) {
						result = ((BigInteger) value1).divide((BigInteger) value2);
					} else {
						if (value2 instanceof Number) {
							result = ((BigInteger) value1).divide(BigInteger.valueOf(((Number) value2).longValue()));
						} else {
							logFailure(msg);
							return FAILURE;
						}
					}
				}
			} else {
				if (value1 instanceof Number) {
					if (value2 instanceof BigDecimal) {
						BigDecimal second = (BigDecimal) value2;
						result = new BigDecimal(((Number) value1).longValue()).setScale(second.scale()).divide(second,
								BigDecimal.ROUND_HALF_UP);
					} else {
						if (value2 instanceof BigInteger) {
							result = BigInteger.valueOf(((Number) value1).longValue()).divide((BigInteger) value2);
						} else {
							if (value2 instanceof Number) {
								result = ((Number) value1).longValue() / ((Number) value2).longValue();
							} else {
								logFailure(msg);
								return FAILURE;
							}
						}
					}
				} else {
					logFailure(msg);
					return FAILURE;
				}
			}
		}
		logSuccess(msg);
		return new FunctionEvalResult(true, result);
	}

	@Override
	public String getOutputName() {
		return outputName;
	}

	@Override
	public String[] getOutputContext() {
		return outputContext;
	}

}
