package net.sf.aguacate.function.spi;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.function.FunctionEvalResult;
import net.sf.aguacate.util.parameter.Parameter;

public abstract class AbstractFunctionN extends AbstractFunction {

	private final Parameter[] parameters;

	private final String message;

	public AbstractFunctionN(Collection<String> methods, String name, String message, List<Parameter> parameters) {
		super(methods, name);
		this.parameters = parameters.toArray(new Parameter[parameters.size()]);
		this.message = message;
	}

	@Override
	public FunctionEvalResult evaluate(FunctionContext functionContext, Map<String, Object> context) {
		int length = parameters.length;
		Object[] values = new Object[length];
		for (int i = 0; i < length; i++) {
			Parameter parameter = parameters[i];
			values[i] = parameter.calculateContext(context).get(parameter.getName());
		}
		String msg = MessageFormat.format(message, values);
		return evaluate(functionContext, values, msg);
	}

	protected abstract FunctionEvalResult evaluate(FunctionContext functionContext, Object[] values, String msg);

}
