package net.sf.aguacate.function.spi;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;

import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.function.FunctionEvalResult;
import net.sf.aguacate.util.parameter.Parameter;

public abstract class AbstractFunction1 extends AbstractFunction {

	private final Parameter parameter;

	private final String message;

	public AbstractFunction1(Collection<String> methods, String name, String message, Parameter parameter) {
		super(methods, name);
		this.parameter = parameter;
		this.message = message;
	}

	@Override
	public FunctionEvalResult evaluate(FunctionContext functionContext, Map<String, Object> context) {
		Object value = parameter.calculateContext(context).get(parameter.getName());
		String msg = MessageFormat.format(message, value);
		return evaluate(functionContext, msg, value);
	}

	protected abstract FunctionEvalResult evaluate(FunctionContext functionContext, String msg, Object value);

}
