package net.sf.aguacate.function.spi;

import java.util.Collection;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import net.sf.aguacate.function.Function;
import net.sf.aguacate.function.FunctionEvalResult;

public abstract class AbstractFunction implements Function {

	private static final Logger MESSAGE_LOGGER = LogManager.getLogger("aguacate.function");

	protected static final FunctionEvalResult SUCCESS = new FunctionEvalResult(true);

	protected static final FunctionEvalResult FAILURE = new FunctionEvalResult(false);

	private final Collection<String> methods;

	private final String name;

	public AbstractFunction(Collection<String> methods, String name) {
		this.methods = methods;
		this.name = name;
	}

	@Override
	public boolean validFor(String method) {
		return methods.contains(method);
	}

	@Override
	public String getName() {
		return name;
	}

	protected void logFailure(String msg) {
		MESSAGE_LOGGER.warn("{}({}): failure", msg, getName());
	}

	protected void logSuccess(String msg) {
		MESSAGE_LOGGER.info("{}({}): success", msg, getName());
	}

}
