package net.sf.aguacate.function;

import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;

import net.sf.aguacate.util.config.database.DatabaseInterface;

public interface FunctionContext extends Closeable {

	DatabaseInterface databaseInterface();

	String getMethod();

	Connection acquireConnection() throws SQLException;

	Map<String, Object> get(String name);

	void rollback();

	void handleNotFound();

	void handleEmpty();

	void handleOk(Object object);

}
